-- Version 1.0.1 (fixed for Lua 5.0)

-- Depends on MusicLengthSeconds, which is only in OITG beta 1
-- and StepMania 4.0 CVS/SVN, so beware of that!
function GetGenre()
	local cursong = GAMESTATE:GetCurrentSong()
	if not cursong then return "" end

	-- convenience variables, since the # op isn't in LUA 5.0
	local NumMain = table.getn(Genre.Main)
	local NumDesc1 = table.getn(Genre.Desc1)
	local NumDesc2 = table.getn(Genre.Desc2)
	
	-- randomseed seems to truncate float values, but we need more randomness.
	-- move the number over a few digits to compensate.
	local factor = 10000
	local length = cursong:MusicLengthSeconds()*factor

	-- if this is a patched OGG, then set this genre instead
	if length == 1050000 then return "Crunchy H4X" end

	-- lol hi dax
	local artist = cursong:GetDisplayArtist()
	if artist == "Dax" then return "Alternative Crapcore" end

	-- set the PRNG seed with the music length
	math.randomseed( length )
	
	-- lol hi kyle, unicode
	if artist == "Banzai" or artist == "Inspector K" or artist == "KaW" or artist == "Kbit" or artist == "☺"
	then
		return Genre.Desc1[math.random(NumDesc1)] .. " K-" .. Genre.Main[math.random(NumMain)]
	end
	
	local songname = cursong:GetDisplayFullTitle()
	if songname == "Chopstix"
	then
		return "Asia"
	end
	
	
	--Vary the amount of words returned
	local wordval = math.random(1,12)
	
	-- 1/6 chance of one-word genre
	if wordval == 1 or wordval == 2 then return Genre.Main[math.random(NumMain)] end
	
	-- 1/12 chance of three-word genre
	if wordval == 12 then
		return Genre.Desc2[math.random(NumDesc2)] .. " " .. Genre.Desc1[math.random(NumDesc1)]
		.. " " .. Genre.Main[math.random(NumMain)]
	end
	
	-- fall-through case: return two words
	return Genre.Desc1[math.random(table.getn(Genre.Desc1))] .. " " .. Genre.Main[math.random(table.getn(Genre.Main))]
end